/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.ceutils;

import filenet.pe.ceutils.ConnectionPoint;
import filenet.pe.ceutils.ConnectionPoints;
import filenet.vw.base.PathUtils;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.ntutil.RegKey;
import filenet.vw.server.Configuration;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.security.InvalidParameterException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Node;

public class CPMigrateTool {
    private static final String HELP_MSG = "\n\nThis tool is used to migrate the eProcess routers \n(from the Windows registry, vwtaskman.xml or a source file) to the P8 4.0 connection points.\nThe Isolated Regions, connection points will be created with the existing \ninformation such as routername, and isolated region number.  An output file will \nbe created to contain the information.\n\nUsage:\n\tfilenet.pe.ceutils.CPMigrateTool \n\t\t/username <username> \n\t\t/pw <password> \n\t\t/peServer <P8 4.0 PE name> \n\t\tIf the parameters are not specified, they will be prompted..\n\n\t\tOptional parameters:\n\t\t[/source <file containing routernames, region#, and optional regionPw>]\n\t\t[/pePort <pePort>] \n\t\t[/regPw <region password>]\n\t\t[/ceURI <ceServerUri>]\n\t\t[/outDir <path to store the P8PECP.properties>]\n\t\t[/vwtaskman.xml <fully qualified path for vwtaskman.xml>]\n\t\t[/full <retrieve all the connection points defined in the CEServer>]\n\t\t[/listOnly <ONLY retrieve all the connection points defined in the CEServer, no migration..., when this is set, fullMode is enabled automatically>]\n\t\t[/inDevelopment -- if set, no connection points will be created in the CE Server.\n\t\t\tAlso, development mode uses a different key for testing purpose..\n\t\t[/regkey <regkey for importing - HKCU for HKEY_CURRENT_USER, HKLM for HKey Local Machine>\n\n\tor /inputfile <fileName with the properties for the params>\n\n\tDefault values: \n\tpePort = 32776\n\tregPw = region number,e.g. for region 1, regPw is 1\n\tceURI -- search in path for WcmApiConfig.properties, RemoteServerUrl\n\tvwtaskman.xml -- looks for the file in the classpath.. If not there,then no import from vwtaskman.xml\n\toutDir -- same as vwtaskman.xml param if specified or valid.  Otherwise, \n\t\tsame location with WcmApiConfig.properties, or java.home location ..\n\tregKey -- HKLM\\System\\CurrentControlSet\\Services\\VWServices\\Parameters\\Routers\n\t\tIf inDevelopment is set, then HKCU\\Software\\FileNet\\Quynh\\Services\\VWServices\\Parameters\\Routers\n\nExample:\n\t java -cp pw.jar;Jace.jar;wasp.jar -Djava.security.auth.login.config=C:\\p8\\3PT\\FileNET\\CE_API\\config\\jaas.conf.WSI -Dwasp.location=C:\\p8\\3PT\\FileNET\\CE_API\\wsi filenet.pe.ceutils.CPMigrateTool /inputfile=CPMigrateTool.properties";
    private String username;
    private String pw;
    private String peServer;
    private String regionPw;
    private String ceURI;
    private String ceServer;
    private String vwtaskman_xml;
    private String outDir;
    private String source;
    private String regKey;
    private String p8PECPFileName;
    int pePort;
    int regKey_HK_Index;
    boolean fullMode;
    boolean inDevelopment;
    boolean listOnly;
    private static final String PECP_FILE_NAME = "P8PECP.properties";
    Hashtable connectionPoints = new Hashtable();

    protected static void printUsage(String errorMessage) {
        if (errorMessage != null) {
            CPMigrateTool.msg("\n---------------- " + errorMessage + " --------------");
        }
        CPMigrateTool.msg(HELP_MSG);
        System.exit(1);
    }

    private static String prompt(String promptName) throws Exception {
        Object res = null;
        System.out.print(promptName + ": ");
        char c = '\u0000';
        StringBuffer buf = new StringBuffer();
        while ((c = (char)System.in.read()) != '\n' && c != '\uffffffff') {
            if (c == '\t' || c == '\r' || c == '\n') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    private static void msg(String s) {
        System.out.println(s);
    }

    private void getRegKey(VWCommandLineArgs c) {
        this.inDevelopment = c.isPresent("inDevelopment");
        this.regKey = c.getParameter("regKey");
        if (this.regKey != null) {
            if (this.regKey.startsWith("HKLM\\")) {
                this.regKey_HK_Index = 1;
                this.regKey = this.regKey.substring(5);
            } else if (this.regKey.startsWith("HKCU\\")) {
                this.regKey_HK_Index = 2;
                this.regKey = this.regKey.substring(5);
            } else {
                this.regKey = null;
            }
        }
        if (this.regKey == null || this.regKey.trim().length() == 0) {
            if (this.inDevelopment) {
                this.regKey_HK_Index = 2;
                this.regKey = "Software\\FileNet\\Quynh\\Services\\VWServices\\Parameters\\Routers";
            } else {
                this.regKey_HK_Index = 1;
                this.regKey = "System\\CurrentControlSet\\Services\\VWServices\\Parameters\\Routers";
            }
        }
    }

    protected CPMigrateTool(VWCommandLineArgs c) throws Exception {
        File f;
        this.getRegKey(c);
        this.username = c.getParameter("username");
        if (this.username == null) {
            this.username = CPMigrateTool.prompt("Username");
        }
        this.pw = c.getParameter("pw");
        if (this.pw == null) {
            this.pw = CPMigrateTool.prompt("Password");
        }
        this.peServer = c.getParameter("peServer");
        if (this.peServer == null) {
            this.peServer = CPMigrateTool.prompt("P8 PE Server name");
        }
        this.username = this.username.trim();
        this.pw = this.pw.trim();
        this.peServer = this.peServer.trim();
        if (this.username.length() == 0) {
            CPMigrateTool.printUsage("No user name was given..");
        }
        this.pePort = c.getIntParameter("pePort", 32776);
        this.regionPw = c.getParameter("regPw");
        this.ceURI = c.getParameter("ceURI");
        if (this.ceURI == null) {
            this.ceURI = Configuration.GetCEURI(null, null);
        }
        if (this.ceURI == null) {
            CPMigrateTool.printUsage("NO CEURI IS FOUND!!!");
        }
        URI ceuri = new URI(this.ceURI);
        this.ceServer = ceuri.getHost();
        this.fullMode = c.isPresent("full");
        this.listOnly = c.isPresent("listOnly");
        if (this.listOnly) {
            this.fullMode = true;
        }
        this.vwtaskman_xml = c.getParameter("vwtaskman.xml");
        if (this.vwtaskman_xml == null) {
            try {
                this.vwtaskman_xml = new PathUtils().getResourceLocation("vwtaskman.xml");
            }
            catch (Exception e) {}
        } else {
            f = new File(this.vwtaskman_xml);
            if (!f.exists() || !f.canRead()) {
                CPMigrateTool.printUsage(this.vwtaskman_xml + " is not accessible.  Does not exist or cannot read it..");
            }
        }
        this.outDir = c.getParameter("outDir");
        if (this.outDir == null) {
            if (this.vwtaskman_xml != null) {
                this.outDir = this.vwtaskman_xml;
            } else {
                this.outDir = Configuration.GetGlobalConfigurationPath(null, null);
                if (this.outDir == null) {
                    try {
                        this.outDir = new PathUtils().getResourceLocation("WcmApiConfig.properties");
                        f = new File(this.outDir);
                        this.outDir = f.getParent();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.outDir == null) {
                    this.outDir = System.getProperty("java.home");
                }
            }
        }
        if (this.outDir != null) {
            f = new File(this.outDir);
            if (!f.exists() || !f.canWrite()) {
                CPMigrateTool.printUsage(this.outDir + " is not accessible.  Does not exist or cannot write to it.");
            }
            File f2 = new File(f, PECP_FILE_NAME);
            this.p8PECPFileName = f2.getCanonicalPath();
        }
        this.source = c.getParameter("source");
        if (!(this.source == null || (f = new File(this.source)).exists() && f.canRead())) {
            CPMigrateTool.printUsage(this.source + " is not accessible.  Does not exist or can not read from it.");
        }
    }

    protected void summarizeInputParams() {
        CPMigrateTool.msg("----------- PARAMETER SUMMARY ------------");
        CPMigrateTool.msg("Username = " + this.username);
        CPMigrateTool.msg("Password = " + this.pw);
        CPMigrateTool.msg("PEServer = " + this.peServer);
        CPMigrateTool.msg("PEPort = " + this.pePort);
        CPMigrateTool.msg("CE URI = " + this.ceURI);
        CPMigrateTool.msg("CE Server = " + this.ceServer);
        if (this.listOnly) {
            CPMigrateTool.msg("No migration will be done.");
        } else {
            CPMigrateTool.msg("VWTaskman.xml = " + this.vwtaskman_xml);
            if (this.regionPw != null) {
                CPMigrateTool.msg("RegionPw = " + this.regionPw);
            }
            if (this.source != null) {
                CPMigrateTool.msg("Source = " + this.source);
            }
            if (this.regKey != null) {
                CPMigrateTool.msg("Read from Registry Key = " + this.regKey);
            }
        }
        CPMigrateTool.msg("Output = " + this.p8PECPFileName);
        if (this.fullMode) {
            CPMigrateTool.msg("P8PECP.properties will be updated with connection points from the CE.");
        }
        CPMigrateTool.msg("---------------------------------------- ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateFromFile() {
        if (this.source == null) {
            return;
        }
        String m_method = "migrateFromFile (" + this.source + ")";
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(new File(this.source)));
            int i = 0;
            while ((line = reader.readLine()) != null) {
                ++i;
                try {
                    String tempRegionPw;
                    String[] tokens = line.split(",");
                    if (tokens.length < 2) {
                        throw new InvalidParameterException("Missing connection point name or region number.");
                    }
                    String string = tempRegionPw = tokens.length > 2 ? tokens[2] : this.regionPw;
                    if (tempRegionPw == null) {
                        tempRegionPw = tokens[1];
                    }
                    int regNum = Integer.parseInt(tokens[1]);
                    this.addConnectionPoint(tokens[0], regNum, tempRegionPw);
                }
                catch (Exception e) {
                    CPMigrateTool.msg("Line [" + i + "]: Exception: " + e.getLocalizedMessage() + ", line=" + line);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateFromVWTASKMAN_XML() {
        String m_method = "migrateFromVWTASKMAN_XML";
        FileInputStream f = null;
        try {
            Node routerDefinition;
            f = new FileInputStream(this.vwtaskman_xml);
            VWXMLWrapper w = new VWXMLWrapper(f);
            Node routerAdminNode = VWXMLWrapper.getNodeNamed(w.getRootNode(), "RouterAdminNode");
            if (routerAdminNode != null && (routerDefinition = VWXMLWrapper.getNodeNamed(routerAdminNode, "RouterDefinition")) != null) {
                Node[] routers = VWXMLWrapper.getNodesNamed(routerDefinition, "Router");
                int nRouters = routers == null ? 0 : routers.length;
                for (int i = 0; i < nRouters; ++i) {
                    String routerName = VWXMLWrapper.getNodeAttribute(routers[i], "Name");
                    String sRegionNum = VWXMLWrapper.getNodeAttribute(routers[i], "Region");
                    int regNum = Integer.parseInt(sRegionNum);
                    String tempRegionPw = this.regionPw == null ? sRegionNum : this.regionPw;
                    this.addConnectionPoint(routerName, regNum, this.regionPw);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void migrateFromRegistryKey() {
        String m_method = "migrateFromRegistryKey";
        try {
            RegKey aRegKey = new RegKey(this.regKey_HK_Index, this.regKey, 2);
            RegKey[] subkeys = aRegKey.getSubKeys();
            int nSubkeys = subkeys == null ? 0 : subkeys.length;
            for (int i = 0; i < nSubkeys; ++i) {
                String routerName = subkeys[i].getStringValue("routerName");
                int regNum = subkeys[i].getIntValue("IsolatedRegion");
                String tempRegionPw = this.regionPw == null ? String.valueOf(regNum) : this.regionPw;
                this.addConnectionPoint(routerName, regNum, this.regionPw);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addConnectionPoint(String name, int regNum, String regPw) {
        try {
            ConnectionPoint cp = new ConnectionPoint(name, this.peServer, this.pePort, regNum, this.ceServer);
            if (!this.inDevelopment) {
                ConnectionPoints.AddOrUpdateConnectionPoint(cp, regPw, this.ceURI, this.username, this.pw, true, false, false);
            }
            this.connectionPoints.put(name, cp);
            CPMigrateTool.msg("addConnectionPoint  " + cp + " (" + regPw + ")");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpToFile() {
        PrintWriter f = null;
        try {
            if (this.connectionPoints.size() == 0) {
                CPMigrateTool.msg("Nothing to write to " + this.p8PECPFileName);
                return;
            }
            CPMigrateTool.msg("dumpToFile " + this.p8PECPFileName);
            f = new PrintWriter(new BufferedWriter(new FileWriter(this.p8PECPFileName)));
            Enumeration keysEnum = this.connectionPoints.keys();
            while (keysEnum.hasMoreElements()) {
                String key = (String)keysEnum.nextElement();
                ConnectionPoint value = (ConnectionPoint)this.connectionPoints.get(key);
                f.println(value.Name + "," + value.BrokerPort + "," + value.DNSName + "," + value.IsolatedRegionNumber);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void listAllCPs() {
        try {
            ConnectionPoint[] listCPs = ConnectionPoints.GetConnectionPointsNoIdentityTokens(this.ceURI, this.username, this.pw);
            int nCPs = listCPs == null ? 0 : listCPs.length;
            for (int i = 0; i < nCPs; ++i) {
                CPMigrateTool.msg("listAllCPs[" + i + "]=" + listCPs[i]);
                this.connectionPoints.put(listCPs[i].Name, listCPs[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void process() {
        if (!this.listOnly) {
            this.migrateFromFile();
            this.migrateFromVWTASKMAN_XML();
            this.migrateFromRegistryKey();
        }
        if (this.fullMode) {
            this.listAllCPs();
        }
        this.dumpToFile();
    }

    public static void main(String[] args) {
        try {
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            if (c.isPresent("h") || c.isPresent("H") || c.isPresent("?")) {
                CPMigrateTool.printUsage("HELP");
            }
            CPMigrateTool t = new CPMigrateTool(c);
            t.summarizeInputParams();
            t.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

